# Running the Project with Docker

This guide shows how to run the Insurance app in Docker from the project root: `/home/kasbix/project/insurance/insurance`.

If you need a deeper, step‑by‑step walkthrough, see `DOCKER_SETUP.md` in the repo root.

## Prerequisites

- Docker Engine 20.10+
- Docker Compose v2 (`docker compose` CLI)

## Quick Start

1) Copy env and adjust values if needed:

```bash
cp .env.example .env
```

2) Build and start services:

```bash
docker compose up -d --build
```

3) Install dependencies (inside the app container):

```bash
docker compose exec insurance_app composer install
docker compose exec insurance_app npm install
```

4) Generate app key and run migrations:

```bash
docker compose exec insurance_app php artisan key:generate
docker compose exec insurance_app php artisan migrate
```

5) (Optional) Build frontend assets:

```bash
# Development watcher
docker compose exec insurance_app npm run dev

# Production build
docker compose exec insurance_app npm run build
```

## Access

- App via Nginx: http://localhost
- API: http://localhost/api

If you use a local reverse proxy (e.g., nginx‑proxy) with DNS overrides, you may also access via `http://insurance.local`.

## Common Commands

- Shell into app: `docker compose exec insurance_app bash`
- Logs (all): `docker compose logs -f`
- Logs (one): `docker compose logs -f insurance_app`
- Stop/Start: `docker compose stop` / `docker compose start`
- Restart: `docker compose restart`
- Down: `docker compose down` (add `-v` to remove volumes)

## Troubleshooting

- Fix permissions:

```bash
docker compose exec insurance_app chmod -R 775 storage bootstrap/cache
docker compose exec insurance_app chown -R www-data:www-data storage bootstrap/cache
```

- Rebuild cleanly:

```bash
docker compose down
docker compose build --no-cache
docker compose up -d
```

- DB connection issues:
  - Check status: `docker compose ps`
  - DB logs: `docker compose logs insurance_db`
  - Verify `.env` matches `docker-compose.yml` (use `DB_HOST=insurance_db` when connecting from `insurance_app`).

## Development Workflow (suggested)

```bash
# Start services
docker compose up -d

# Terminal 1: app logs
docker compose logs -f insurance_app

# Terminal 2: queue worker (if used)
docker compose exec insurance_app php artisan queue:work

# Terminal 3: frontend watcher
docker compose exec insurance_app npm run dev
```

## Reference

- Detailed setup and additional commands: `DOCKER_SETUP.md`
- Top‑level overview and context: `ONBOARDING.md`, `README.md`

