<?php

namespace Database\Seeders;

use App\Models\SuperAdmin;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class SuperAdminSeeder extends Seeder
{
    public function run(): void
    {
        $username = env('SUPERADMIN_USERNAME', 'superadmin');
        $password = env('SUPERADMIN_PASSWORD', '123456');
        $email    = env('SUPERADMIN_EMAIL', 'superadmin@example.com');
        $name     = env('SUPERADMIN_NAME', 'Super Admin');

        $superAdmin = SuperAdmin::firstOrNew(['username' => $username]);
        if (! $superAdmin->exists) {
            $superAdmin->id = Str::ulid()->toString();
        }

        $superAdmin->name     = $name;
        $superAdmin->email    = $email;
        $superAdmin->password = Hash::make($password);
        $superAdmin->save();
    }
}
