<?php

namespace Database\Seeders;

use App\Models\Country;
use App\Models\Language;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Throwable;

class ProvinceSeeder extends Seeder
{
    /**
     * @throws Throwable
     */
    public function run(): void
    {
        DB::transaction(function () {
            $canada = Country::query()->where('slug', 'canada')->value('id');
            $provinces = [
                $canada => [
                    [
                        'slug' => 'alberta',
                        'name' => 'Alberta',
                    ],
                    [
                        'slug' => 'british-columbia',
                        'name' => 'British Columbia',
                    ],
                    [
                        'slug' => 'manitoba',
                        'name' => 'Manitoba',
                    ],
                    [
                        'slug' => 'new-brunswick',
                        'name' => 'New Brunswick',
                    ],
                    [
                        'slug' => 'newfoundland-and-labrador',
                        'name' => 'Newfoundland and Labrador',
                    ],
                    [
                        'slug' => 'nova-scotia',
                        'name' => 'Nova Scotia',
                    ],
                    [
                        'slug' => 'ontario',
                        'name' => 'Ontario',
                    ],
                    [
                        'slug' => 'prince-edward-island',
                        'name' => 'Prince Edward Island',
                    ],
                    [
                        'slug' => 'quebec',
                        'name' => 'Quebec',
                    ],
                    [
                        'slug' => 'saskatchewan',
                        'name' => 'Saskatchewan',
                    ],
                    [
                        'slug' => 'northwest-territories',
                        'name' => 'Northwest Territories',
                    ],
                    [
                        'slug' => 'nunavut',
                        'name' => 'Nunavut',
                    ],
                    [
                        'slug' => 'yukon',
                        'name' => 'Yukon',
                    ],
                ],
            ];
            $languageIds = Language::query()->orderBy('id')->pluck('id')->toArray();
            foreach ($provinces as $countryId => $countryProvinces) {
                foreach ($countryProvinces as $province) {
                    $provinceId = DB::table('provinces')->insertGetId([
                        'country_id' => $countryId,
                        'slug'       => $province['slug'],
                    ]);
                    foreach ($languageIds as $languageId) {
                        DB::table('province_translations')->insert([
                            'province_id' => $provinceId,
                            'language_id' => $languageId,
                            'name'        => $province['name'],
                        ]);
                    }
                }
            }
        });
    }
}
