<?php

namespace Database\Seeders;

use App\Models\Plan;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Throwable;

class PriceSeeder extends Seeder
{
    /**
     * @throws Throwable
     */
    public function run(): void
    {
        DB::transaction(function () {
            $jfWith = Plan::query()->where('slug', 'jf-with')->value('id');
            $jfWithout = Plan::query()->where('slug', 'jf-without')->value('id');
            $allianzWith = Plan::query()->where('slug', 'allianz-with')->value('id');
            $allianzWithout = Plan::query()->where('slug', 'allianz-without')->value('id');
            $manulifeWith = Plan::query()->where('slug', 'manulife-with')->value('id');
            $manulifeWithout = Plan::query()->where('slug', 'manulife-without')->value('id');
            $_21stCenturyEnhanced = Plan::query()->where('slug', '21st-century-enhanced')->value('id');
            $_21stCenturyBasic = Plan::query()->where('slug', '21st-century-basic')->value('id');
            $_21stCenturyStandard = Plan::query()->where('slug', '21st-century-standard')->value('id');
            $prices = [
                $jfWith               => [
                    'covers' => [10_000, 15_000, 25_000, 50_000, 100_000, 150_000, 200_000, 300_000],
                    'costs'  => [
                        '0-25'  => [1.79, 2.14, 2.38, 2.61, 3.77, 4.52, 5.65, 6.55],
                        '26-40' => [1.95, 2.33, 2.61, 2.88, 4.22, 4.89, 6.12, 7.10],
                        '41-60' => [2.25, 2.68, 3.00, 3.27, 4.41, 4.94, 7.55, 8.76],
                        '61-64' => [2.56, 3.27, 3.92, 4.22, 4.94, 5.78, 8.33, 9.65],
                        '65-69' => [3.15, 4.11, 4.96, 5.04, 6.24, 7.77, 9.71, 11.27],
                        '70-74' => [5.09, 6.64, 7.98, 8.77, 9.77, 12.78, 15.97, 18.38],
                        '75-79' => [6.09, 7.92, 9.41, 9.98, 12.17, 14.49, 18.91, 21.00],
                        '80-85' => [9.98, null, 13.65, 16.30, 19.95, null, null, null],
                        '86-'   => [null, null, null, null, null, null, null, null],
                    ],
                ],
                $jfWithout            => [
                    'covers' => [10_000, 15_000, 25_000, 50_000, 100_000, 150_000, 200_000, 300_000],
                    'costs'  => [
                        '0-25'  => [1.14, 1.43, 1.55, 1.70, 2.28, 2.72, 3.40, 4.41],
                        '26-40' => [1.28, 1.55, 1.70, 1.85, 2.65, 3.09, 3.85, 4.78],
                        '41-60' => [1.43, 1.79, 1.99, 2.28, 3.38, 4.05, 6.11, 6.07],
                        '61-64' => [1.84, 2.18, 2.75, 3.31, 3.97, 4.70, 6.75, 6.76],
                        '65-69' => [2.10, 2.74, 3.09, 3.68, 5.08, 5.45, 7.40, 8.02],
                        '70-74' => [3.31, 4.39, 4.30, 6.16, 6.99, 9.00, 12.50, 12.96],
                        '75-79' => [4.05, 5.26, 5.08, 7.16, 8.76, 10.25, 13.58, 14.98],
                        '80-85' => [5.93, 7.64, 9.35, 10.00, 13.94, 15.50, 18.85, null],
                        '86-'   => [9.13, 12.00, 14.30, 16.40, 22.30, null, null, null, null],
                    ],
                ],
                $allianzWith          => [
                    'covers' => [25_000, 50_000, 100_000, 500_000],
                    'costs'  => [
                        '0-25'  => [2.34, 2.69, 3.41, 7.73],
                        '26-34' => [2.52, 2.87, 3.76, 8.49],
                        '35-39' => [2.69, 3.00, 3.90, 9.08],
                        '40-54' => [3.01, 3.41, 4.97, 11.15],
                        '55-59' => [3.72, 4.19, 6.05, 11.71],
                        '60-64' => [4.92, 5.77, 7.14, 13.21],
                        '65-69' => [7.07, 8.84, 10.71, 15.69],
                        '70-74' => [8.42, 10.00, 12.56, 24.61],
                        '75-79' => [12.46, 14.80, 18.59, 36.42],
                        '80-84' => [22.60, 28.64, 36.24, 68.72],
                        '85-89' => [63.72, 80.79, 102.21, 226.92],
                    ],
                ],
                $allianzWithout       => [
                    'covers' => [25_000, 50_000, 100_000, 500_000],
                    'costs'  => [
                        '0-25'  => [null, null, null, null],
                        '26-34' => [null, null, null, null],
                        '35-39' => [null, null, null, null],
                        '40-54' => [null, null, null, null],
                        '55-59' => [null, null, null, null],
                        '60-64' => [null, null, null, null],
                        '65-69' => [null, null, null, null],
                        '70-74' => [null, null, null, null],
                        '75-79' => [null, null, null, null],
                        '80-84' => [null, null, null, null],
                        '85-89' => [null, null, null, null],
                    ],
                ],
                $manulifeWith         => [
                    'covers' => [15_000, 25_000, 50_000, 100_000, 150_000],
                    'costs'  => [
                        '0-25'  => [2.43, 2.51, 2.97, 3.69, 5.08],
                        '26-34' => [2.48, 2.68, 3.10, 3.98, 5.42],
                        '35-39' => [2.59, 2.83, 3.25, 4.17, 6.28],
                        '40-54' => [2.97, 3.25, 3.59, 5.24, 7.34],
                        '55-59' => [3.36, 3.41, 4.05, 5.65, 7.85],
                        '60-64' => [3.85, 4.29, 5.03, 6.60, 8.38],
                        '65-69' => [4.35, 5.24, 5.76, 7.50, 10.47],
                        '70-74' => [6.16, 7.34, 8.69, 10.91, null],
                        '75-79' => [7.34, 9.32, 11.15, 14.16, null],
                        '80-85' => [9.85, 11.62, 12.57, 14.41, null],
                    ],
                ],
                $manulifeWithout      => [
                    'covers' => [15_000, 25_000, 50_000, 100_000, 150_000],
                    'costs'  => [
                        '0-25'  => [2.21, 2.28, 2.63, 3.35, 4.62],
                        '26-34' => [2.25, 2.44, 2.82, 3.62, 4.93],
                        '35-39' => [2.35, 2.57, 2.95, 3.79, 5.71],
                        '40-54' => [2.70, 2.95, 3.26, 4.76, 6.67],
                        '55-59' => [3.05, 3.10, 3.68, 5.14, 7.14],
                        '60-64' => [3.50, 3.90, 4.57, 6.00, 7.62],
                        '65-69' => [3.95, 4.76, 5.24, 6.82, 9.52],
                        '70-74' => [5.60, 6.67, 7.90, 9.92, null],
                        '75-79' => [6.67, 8.47, 10.14, 12.87, null],
                        '80-85' => [8.95, 10.56, 11.43, 13.10, null],
                    ],
                ],
                $_21stCenturyEnhanced => [
                    'covers' => [15_000, 25_000, 50_000, 100_000, 150_000, 200_000],
                    'costs'  => [
                        '0-25'  => [2.58, 2.75, 3.09, 4.13, 4.83, 6.26],
                        '26-34' => [2.79, 2.98, 3.35, 4.43, 5.39, 6.94],
                        '35-39' => [2.91, 3.03, 3.37, 4.72, 5.62, 7.10],
                        '40-54' => [3.09, 3.52, 4.01, 5.78, 6.91, 8.62],
                        '55-59' => [3.47, 3.70, 4.30, 6.30, 7.57, 9.19],
                        '60-64' => [4.35, 4.80, 5.84, 7.51, 8.90, 9.94],
                        '65-69' => [5.08, 5.66, 6.67, 8.93, 10.28, 11.77],
                        '70-74' => [7.51, 8.32, 10.20, 12.83, 14.33, 19.01],
                        '75-79' => [8.90, 10.17, 13.39, 15.95, 17.70, 21.60],
                        '80-85' => [13.29, 15.53, 18.27, 21.42, 27.65, 34.78],
                        '86-'   => [null, null, null, null, null, null],
                    ],
                ],
                $_21stCenturyBasic    => [
                    'covers' => [15_000, 25_000, 50_000, 100_000, 150_000, 200_000],
                    'costs'  => [
                        '0-25'  => [1.53, 1.63, 1.79, 2.41, 2.88, 3.73],
                        '26-34' => [1.79, 1.91, 2.08, 2.97, 3.67, 4.72],
                        '35-39' => [1.83, 1.95, 2.13, 3.03, 3.77, 4.84],
                        '40-54' => [2.01, 2.29, 2.63, 3.74, 4.63, 5.21],
                        '55-59' => [2.04, 2.29, 2.63, 3.74, 4.68, 5.31],
                        '60-64' => [2.36, 2.91, 3.50, 4.18, 5.20, 5.54],
                        '65-69' => [2.69, 3.26, 3.88, 5.36, 6.02, 6.54],
                        '70-74' => [4.23, 4.54, 6.50, 7.37, 9.04, 10.84],
                        '75-79' => [5.20, 5.36, 7.55, 9.14, 10.34, 11.53],
                        '80-85' => [7.60, 8.78, 9.46, 14.05, 18.14, 23.96],
                        '86-'   => [12.21, 15.26, 22.14, 23.78, null, null],
                    ],
                ],
                $_21stCenturyStandard => [
                    'covers' => [15_000, 25_000, 50_000, 100_000, 150_000, 200_000],
                    'costs'  => [
                        '0-25'  => [1.87, 1.99, 2.19, 2.94, 3.51, 4.54],
                        '26-34' => [2.18, 2.33, 2.54, 3.36, 4.48, 5.75],
                        '35-39' => [2.24, 2.38, 2.60, 3.70, 4.60, 5.90],
                        '40-54' => [2.45, 2.80, 3.21, 4.56, 5.65, 6.35],
                        '55-59' => [2.48, 2.80, 3.21, 4.56, 5.71, 6.48],
                        '60-64' => [2.88, 3.55, 4.27, 5.10, 6.34, 6.76],
                        '65-69' => [3.27, 3.97, 4.74, 6.53, 7.34, 7.97],
                        '70-74' => [5.16, 5.53, 7.93, 8.98, 11.03, 13.22],
                        '75-79' => [6.35, 6.53, 9.21, 11.15, 12.61, 14.06],
                        '80-85' => [9.26, 10.70, 11.53, 17.14, 22.12, 29.23],
                        '86-'   => [null, null, null, null, null, null],
                    ],
                ],
            ];
            foreach ($prices as $planId => $planPrice) {
                $indices = array_keys($planPrice['covers']);
                foreach ($planPrice['costs'] as $ageRange => $costs) {
                    [$ageFrom, $ageTo] = explode('-', $ageRange);
                    foreach ($indices as $index) {
                        DB::table('prices')->insert([
                            [
                                'plan_id'         => $planId,
                                'age_from'        => $ageFrom,
                                'age_to'          => is_numeric($ageTo) ? $ageTo : null,
                                'insurance_cover' => $planPrice['covers'][$index],
                                'daily_cost'      => $costs[$index],
                                'is_entry'        => 1,
                                'is_active'       => !is_null($costs[$index]),
                            ],
                            [
                                'plan_id'         => $planId,
                                'age_from'        => $ageFrom,
                                'age_to'          => is_numeric($ageTo) ? $ageTo : null,
                                'insurance_cover' => $planPrice['covers'][$index],
                                'daily_cost'      => $costs[$index],
                                'is_entry'        => 0,
                                'is_active'       => !is_null($costs[$index]),
                            ],
                        ]);
                    }
                }
            }
        });
    }
}
