<?php

namespace Database\Seeders;

use App\Models\Company;
use App\Models\Language;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Throwable;

class DeductibleSeeder extends Seeder
{
    /**
     * @throws Throwable
     */
    public function run(): void
    {
        DB::transaction(function () {
            $en = Language::query()->where('code', 'en')->value('id');
            $zh = Language::query()->where('code', 'zh')->value('id');
            $jf = Company::query()->where('slug', 'jf')->value('id');
            $allianz = Company::query()->where('slug', 'allianz')->value('id');
            $manulife = Company::query()->where('slug', 'manulife')->value('id');
            $_21stCentury = Company::query()->where('slug', '21st-century')->value('id');
            $deductibles = [
                $jf           => [
                    [
                        'slug'       => 'jf-0',
                        'amount'     => 0,
                        'discount'   => 0,
                        'amountEn'   => '$0 Deductible',
                        'amountZh'   => '0 美元免赔额',
                        'discountEn' => '0% Discount',
                        'discountZh' => '0% 折扣',
                    ],
                    [
                        'slug'       => 'jf-100',
                        'amount'     => 100,
                        'discount'   => 5,
                        'amountEn'   => '$100 Deductible',
                        'amountZh'   => '100 美元免赔额',
                        'discountEn' => '5% Discount',
                        'discountZh' => '5% 折扣',
                    ],
                    [
                        'slug'       => 'jf-500',
                        'amount'     => 500,
                        'discount'   => 15,
                        'amountEn'   => '$500 Deductible',
                        'amountZh'   => '500 美元免赔额',
                        'discountEn' => '15% Discount',
                        'discountZh' => '15% 折扣',
                    ],
                    [
                        'slug'       => 'jf-1000',
                        'amount'     => 1_000,
                        'discount'   => 20,
                        'amountEn'   => '$1,000 Deductible',
                        'amountZh'   => '1,000 美元免赔额',
                        'discountEn' => '20% Discount',
                        'discountZh' => '20% 折扣',
                    ],
                    [
                        'slug'       => 'jf-3000',
                        'amount'     => 3_000,
                        'discount'   => 30,
                        'amountEn'   => '$3,000 Deductible',
                        'amountZh'   => '3,000 美元免赔额',
                        'discountEn' => '30% Discount',
                        'discountZh' => '30% 折扣',
                    ],
                ],
                $allianz      => [
                    [
                        'slug'       => 'allianz-0',
                        'amount'     => 0,
                        'discount'   => 0,
                        'amountEn'   => '$0 Deductible',
                        'amountZh'   => '0 美元免赔额',
                        'discountEn' => '0% Discount',
                        'discountZh' => '0% 折扣',
                    ],
                    [
                        'slug'       => 'allianz-500',
                        'amount'     => 500,
                        'discount'   => 15,
                        'amountEn'   => '$500 Deductible',
                        'amountZh'   => '500 美元免赔额',
                        'discountEn' => '15% Discount',
                        'discountZh' => '15% 折扣',
                    ],
                ],
                $manulife     => [
                    [
                        'slug'       => 'manulife-0',
                        'amount'     => 0,
                        'discount'   => -5,
                        'amountEn'   => '$0 Deductible',
                        'amountZh'   => '0 美元免赔额',
                        'discountEn' => '5% increase in premiums',
                        'discountZh' => '保费增加5%',
                    ],
                    [
                        'slug'       => 'manulife-75',
                        'amount'     => 75,
                        'discount'   => 0,
                        'amountEn'   => '$75 Deductible',
                        'amountZh'   => '75 美元免赔额',
                        'discountEn' => '0% Discount',
                        'discountZh' => '0% 折扣',
                    ],
                    [
                        'slug'       => 'manulife-500',
                        'amount'     => 500,
                        'discount'   => 15,
                        'amountEn'   => '$500 Deductible',
                        'amountZh'   => '500 美元免赔额',
                        'discountEn' => '15% Discount',
                        'discountZh' => '15% 折扣',
                    ],
                    [
                        'slug'       => 'manulife-1000',
                        'amount'     => 1_000,
                        'discount'   => 0,
                        'amountEn'   => '$1,000 Deductible *Vanishing deductible',
                        'amountZh'   => '1,000 美元免赔额 *消失免赔额',
                        'discountEn' => '20% Discount',
                        'discountZh' => '20% 折扣',
                    ],
                    [
                        'slug'       => 'manulife-2500',
                        'amount'     => 2_500,
                        'discount'   => 25,
                        'amountEn'   => '$2,500 Deductible*',
                        'amountZh'   => '2,500 美元免赔额',
                        'discountEn' => '25% Discount',
                        'discountZh' => '25% 折扣',
                    ],
                    [
                        'slug'       => 'manulife-5000',
                        'amount'     => 5_000,
                        'discount'   => 35,
                        'amountEn'   => '$5,000 Deductible',
                        'amountZh'   => '5,000 美元免赔额',
                        'discountEn' => '35% Discount',
                        'discountZh' => '35% 折扣',
                    ],
                ],
                $_21stCentury => [
                    [
                        'slug'       => '21st-century-0',
                        'amount'     => 0,
                        'discount'   => 0,
                        'amountEn'   => '$0 Deductible',
                        'amountZh'   => '0 美元免赔额',
                        'discountEn' => '0% Discount',
                        'discountZh' => '0% 折扣',
                    ],
                    [
                        'slug'       => '21st-century-100',
                        'amount'     => 100,
                        'discount'   => 5,
                        'amountEn'   => '$100 Deductible',
                        'amountZh'   => '100 美元免赔额',
                        'discountEn' => '5% Discount',
                        'discountZh' => '5% 折扣',
                    ],
                    [
                        'slug'       => '21st-century-250',
                        'amount'     => 250,
                        'discount'   => 10,
                        'amountEn'   => '$250 Deductible',
                        'amountZh'   => '250 美元免赔额',
                        'discountEn' => '10% Discount',
                        'discountZh' => '10% 折扣',
                    ],
                    [
                        'slug'       => '21st-century-500',
                        'amount'     => 500,
                        'discount'   => 15,
                        'amountEn'   => '$500 Deductible',
                        'amountZh'   => '500 美元免赔额',
                        'discountEn' => '15% Discount',
                        'discountZh' => '15% 折扣',
                    ],
                    [
                        'slug'       => '21st-century-1000',
                        'amount'     => 1_000,
                        'discount'   => 20,
                        'amountEn'   => '$1,000 Deductible',
                        'amountZh'   => '1,000 美元免赔额',
                        'discountEn' => '20% Discount',
                        'discountZh' => '20% 折扣',
                    ],
                    [
                        'slug'       => '21st-century-5000',
                        'amount'     => 5_000,
                        'discount'   => 35,
                        'amountEn'   => '$5,000 Deductible',
                        'amountZh'   => '5,000 美元免赔额',
                        'discountEn' => '35% Discount',
                        'discountZh' => '35% 折扣',
                    ],
                    [
                        'slug'       => '21st-century-10000',
                        'amount'     => 10_000,
                        'discount'   => 40,
                        'amountEn'   => '$10,000 Deductible',
                        'amountZh'   => '10,000 美元免赔额',
                        'discountEn' => '40% Discount',
                        'discountZh' => '40% 折扣',
                    ],
                ],
            ];
            foreach ($deductibles as $companyId => $companyDeductibles) {
                foreach ($companyDeductibles as $deductible) {
                    $deductibleId = DB::table('deductibles')->insertGetId([
                        'company_id' => $companyId,
                        'slug'       => $deductible['slug'],
                        'amount'     => $deductible['amount'],
                        'discount'   => $deductible['discount'],
                    ]);
                    DB::table('deductible_translations')->insert([
                        [
                            'deductible_id' => $deductibleId,
                            'language_id'   => $en,
                            'amount'        => $deductible['amountEn'],
                            'discount'      => $deductible['discountEn'],
                        ],
                        [
                            'deductible_id' => $deductibleId,
                            'language_id'   => $zh,
                            'amount'        => $deductible['amountZh'],
                            'discount'      => $deductible['discountZh'],
                        ],
                    ]);
                }
            }
        });
    }
}
