<?php

namespace Database\Seeders;

use App\Models\Language;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Throwable;

class CountrySeeder extends Seeder
{
    /**
     * @throws Throwable
     */
    public function run(): void
    {
        DB::transaction(function () {
            $en = Language::query()->where('code', 'en')->value('id');
            $zh = Language::query()->where('code', 'zh')->value('id');
            $countries = [
                [
                    'slug'   => 'canada',
                    'prefix' => 1,
                    'nameEn' => 'Canada',
                    'nameZh' => '加拿大',
                ],
            ];
            foreach ($countries as $country) {
                $countryId = DB::table('countries')->insertGetId([
                    'slug'   => $country['slug'],
                    'prefix' => $country['prefix'],
                ]);
                DB::table('country_translations')->insert([
                    [
                        'country_id'  => $countryId,
                        'language_id' => $en,
                        'name'        => $country['nameEn'],
                    ],
                    [
                        'country_id'  => $countryId,
                        'language_id' => $zh,
                        'name'        => $country['nameZh'],
                    ],
                ]);
            }
        });
    }
}
