<?php

namespace Database\Seeders;

use App\Models\Language;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Throwable;

class CompanySeeder extends Seeder
{
    /**
     * @throws Throwable
     */
    public function run(): void
    {
        DB::transaction(function () {
            $en = Language::query()->where('code', 'en')->value('id');
            $zh = Language::query()->where('code', 'zh')->value('id');
            $companies = [
                [
                    'slug'          => 'jf',
                    'logo'          => 'seeder/companies/jf.png',
                    'url'           => 'https://www.jfgroup.ca/',
                    'min_cost'      => 25,
                    'nameEn'        => 'JF Visitor to Canada Plan',
                    'nameZh'        => 'JF Visitor to Canada Plan',
                    'descriptionEn' => 'The best price in the market, less than 1,300 Canadian dollars, you can submit claims online, and receive the claim payment through bank transfer in about two weeks. Berkley\'s competitive products have basically the same regulations and prices.',
                    'descriptionZh' => '市场最优价格，不到1300加元，可在线提交理赔，约两周后通过银行转账收到理赔款。Berkley的竞品产品，规章制度和价格基本相同。',
                ],
                [
                    'slug'          => 'allianz',
                    'logo'          => 'seeder/companies/allianz.png',
                    'url'           => 'https://www.allianz.com/en.html',
                    'min_cost'      => 20,
                    'nameEn'        => 'Allianz - Visitors to Canada',
                    'nameZh'        => 'Allianz - Visitors to Canada',
                    'descriptionEn' => 'Convenient claims settlement and favorable prices',
                    'descriptionZh' => '理赔便捷、价格优惠',
                ],
                [
                    'slug'          => 'manulife',
                    'logo'          => 'seeder/companies/manulife.png',
                    'url'           => 'https://www.manulife.com/',
                    'min_cost'      => 0,
                    'nameEn'        => 'Manulife - Travel Insurance for visitors to Canada Emergency Medical',
                    'nameZh'        => 'Manulife - Travel Insurance for visitors to Canada Emergency Medical',
                    'descriptionEn' => 'MANULIFE Insurance Company\'s products have a higher price advantage for people aged 80-85. The cost of each medical visit is less than the deductible amount and needs to be borne by the patient (deductible is not recommended).',
                    'descriptionZh' => '宏利保险公司的产品针对80-85岁人群有较高的价格优势，每次就诊费用低于免赔额，需要患者自行承担（不建议设置免赔额）。',
                ],
                [
                    'slug'          => '21st-century',
                    'logo'          => 'seeder/companies/21st.png',
                    'url'           => 'https://www.21st.com/',
                    'min_cost'      => 25,
                    'nameEn'        => '21st – Century',
                    'nameZh'        => '21st – Century',
                    'descriptionEn' => 'Enhanced is the price that covers stable old diseases, and standard is the price that does not cover old diseases. There is no price that does not cover old diseases for people under 55 years old.',
                    'descriptionZh' => '增强型是涵盖稳定型老年疾病的价格，标准型是不涵盖老年疾病的价格。55岁以下人群没有不涵盖老年疾病的价格。',
                ],
            ];
            foreach ($companies as $company) {
                $companyId = DB::table('companies')->insertGetId([
                    'slug'     => $company['slug'],
                    'logo'     => $company['logo'],
                    'url'      => $company['url'],
                    'min_cost' => $company['min_cost'],
                ]);
                DB::table('company_translations')->insert([
                    'company_id'  => $companyId,
                    'language_id' => $en,
                    'name'        => $company['nameEn'],
                    'description' => $company['descriptionEn'],
                ]);
                DB::table('company_translations')->insert([
                    'company_id'  => $companyId,
                    'language_id' => $zh,
                    'name'        => $company['nameZh'],
                    'description' => $company['descriptionZh'],
                ]);
            }
        });
    }
}
