<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class AgentSeeder extends Seeder
{
    private static ?string $password = null;

    public function run(): void
    {
        $ids = [
            '01K2HCYDJPZ09K6Y748KQPY0YM',
            '01K2HCYDRPAWM11081SG80MPZW',
            '01K2HCYDRPAWM11081SG80MPZX',
            '01K2HCYDRPAWM11081SG80MPZY',
            '01K2HCYDRPAWM11081SG80MPZZ',
            '01K2HCYDRPAWM11081SG80MQ00',
            '01K2HCYDRPAWM11081SG80MQ01',
            '01K2HCYDRPAWM11081SG80MQ02',
            '01K2HCYDRPAWM11081SG80MQ03',
            '01K2HCYDRPAWM11081SG80MQ04',
        ];
        $agents = [];
        for ($i = 1; $i <= 10; $i++) {
            $agents[] = [
                'id'       => $ids[$i - 1],
                'username' => 'agent' . $i,
                'password' => self::$password ??= Hash::make('123456'),
                'name'     => 'Agent ' . $i,
            ];
        }
        DB::table('agents')->insert($agents);
    }
}
