<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class AdminSeeder extends Seeder
{
    public function run(): void
    {
        DB::table('admins')->insert([
            'id'       => Str::ulid()->tostring(),
            'username' => 'admin',
            'password' => Hash::make('123456'),
            'name'     => 'Site Admin',
            'api_key'  => Str::upper(Str::random(12)),
            'active_agent' => true,
        ]);
    }
}
