<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('questionnaire_configs', function (Blueprint $table) {
            $table->ulid('id')->primary();
            
            $table->string('name');
            $table->string('slug')->unique();
            $table->string('insurance_company');
            
            $table->integer('min_age')->default(0);
            $table->integer('max_age')->default(120);
            $table->boolean('is_active')->default(true);
            
            // JSON configurations for each step
            $table->json('step1_config')->nullable();
            $table->json('step2_config')->nullable();
            $table->json('step3_config')->nullable();
            $table->json('step4_config')->nullable();
            
            // Rate multipliers
            $table->decimal('rate_a_multiplier', 5, 2)->default(1.00);
            $table->decimal('rate_b_multiplier', 5, 2)->default(1.50);
            $table->decimal('rate_c_multiplier', 5, 2)->default(2.50);
            $table->decimal('smoking_surcharge_percent', 5, 2)->default(10.00);
            
            $table->text('description')->nullable();
            
            $table->softDeletes();
            $table->timestamps();
            
            // Indexes
            $table->index(['insurance_company', 'is_active']);
            $table->index(['min_age', 'max_age']);
            $table->index(['slug']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('questionnaire_configs');
    }
};