<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('people', function (Blueprint $table) {
            $table->ulid('id')->primary();
            $table->foreignUlid('inquiry_id')->constrained('inquiries')->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('deductible_id')->constrained('deductibles')->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('price_id')->constrained('prices')->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('first_name');
            $table->string('last_name');
            $table->dateTime('born_at');
            $table->boolean('is_male');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('people');
    }
};
