<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('deductible_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('deductible_id')->constrained('deductibles')->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('language_id')->constrained('languages')->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('amount');
            $table->string('discount');
            $table->boolean('is_active')->default(1);
            $table->unique(['deductible_id', 'language_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('deductible_translations');
    }
};
