<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('admins', function (Blueprint $table) {
            $table->ulid('id')->primary();
            $table->string('username')->unique();
            $table->string('password');
            $table->string('name');
            $table->string('email')->nullable();
            $table->string('api_key', 12)->unique();
            $table->string('license')->nullable();
            $table->string('domain')->nullable();
            $table->boolean('is_active')->default(1);
            $table->boolean('active_agent')->default(0);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('admins');
    }
};
