<?php

namespace App\Policies;

use App\Models\Admin;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Contracts\Auth\Authenticatable;

class ContentPolicy
{
    use HandlesAuthorization;

    public function viewAny(Authenticatable $user): bool
    {
        return match (get_class($user)) {
            Admin::class => true,
            default      => false,
        };
    }

    public function view(Authenticatable $user): bool
    {
        return match (get_class($user)) {
            Admin::class => true,
            default      => false,
        };
    }

    public function create(Authenticatable $user): bool
    {
        return match (get_class($user)) {
            Admin::class => true,
            default      => false,
        };
    }

    public function update(Authenticatable $user): bool
    {
        return match (get_class($user)) {
            Admin::class => true,
            default      => false,
        };
    }

    public function delete(): bool
    {
        return false;
    }

    public function restore(Authenticatable $user): bool
    {
        return match (get_class($user)) {
            Admin::class => true,
            default      => false,
        };
    }

    public function forceDelete(): bool
    {
        return false;
    }
}
