<?php

namespace App\Models;

use Filament\Models\Contracts\FilamentUser;
use Filament\Models\Contracts\HasName;
use Filament\Panel;
use Illuminate\Database\Eloquent\Concerns\HasUlids;
use Illuminate\Foundation\Auth\User;

class SuperAdmin extends User implements FilamentUser, HasName
{
    use HasUlids;

    protected $table = 'super_admins';

    protected $fillable = [
        'id',
        'username',
        'password',
        'name',
        'email',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Access control for Filament panel
     */
    public function canAccessPanel(Panel $panel): bool
    {
        return $panel->getId() === 'super-admin';
    }

    /**
     * Name for Filament display
     */
    public function getFilamentName(): string
    {
        return $this->name;
    }

    /**
     * Authentication identifier
     */
    public function getAuthIdentifierName(): string
    {
        return 'username';
    }
}
