<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class Price
 * @package App\Models
 *
 * @property int $id
 * @property int $plan_id
 * @property int $age_from
 * @property int $age_to
 * @property int $insurance_cover
 * @property int $daily_cost
 * @property bool $is_entry
 * @property bool $is_active
 *
 * @property Collection<Person> $people
 * @property Plan $plan
 */
class Price extends Model
{
    public $timestamps = false;
    protected $table = 'prices';
    protected $fillable = [
        'id',
        'plan_id',
        'age_from',
        'age_to',
        'insurance_cover',
        'daily_cost',
        'is_entry',
        'is_active',
    ];

    public function people(): HasMany
    {
        return $this->hasMany(Person::class, 'price_id');
    }

    public function plan(): BelongsTo
    {
        return $this->belongsTo(Plan::class, 'plan_id');
    }

    protected function casts(): array
    {
        return [
            'is_entry'  => 'boolean',
            'is_active' => 'boolean',
        ];
    }
}
