<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class PlanTranslation
 * @package App\Models
 *
 * @property int $id
 * @property int $plan_id
 * @property int $language_id
 * @property string $name
 * @property string $description
 * @property bool $is_active
 *
 * @property Language $language
 * @property Plan $plan
 */
class PlanTranslation extends Model
{
    public $timestamps = false;
    protected $table = 'plan_translations';
    protected $fillable = [
        'id',
        'plan_id',
        'language_id',
        'name',
        'description',
        'is_active',
    ];

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class, 'language_id');
    }

    public function plan(): BelongsTo
    {
        return $this->belongsTo(Plan::class, 'plan_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
