<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class Deductible
 * @package App\Models
 *
 * @property int $id
 * @property int $company_id
 * @property string $slug
 * @property int $amount
 * @property int $discount
 * @property bool $is_active
 *
 * @property Company $company
 * @property Collection<Person> $people
 * @property Collection<DeductibleTranslation> $translations
 */
class Deductible extends Model
{
    public $timestamps = false;
    protected $table = 'deductibles';
    protected $fillable = [
        'id',
        'company_id',
        'slug',
        'amount',
        'discount',
        'is_active',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function people(): HasMany
    {
        return $this->hasMany(Person::class, 'deductible_id');
    }

    public function translations(): HasMany
    {
        return $this->hasMany(DeductibleTranslation::class, 'deductible_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
