<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class Country
 * @package App\Models
 *
 * @property int $id
 * @property string $slug
 * @property int $prefix
 * @property bool $is_active
 *
 * @property Collection<Province> $provinces
 * @property Collection<CountryTranslation> $translations
 */
class Country extends Model
{
    public $timestamps = false;
    protected $table = 'countries';
    protected $fillable = [
        'id',
        'slug',
        'prefix',
        'is_active',
    ];

    public function provinces(): HasMany
    {
        return $this->hasMany(Province::class, 'country_id');
    }

    public function translations(): HasMany
    {
        return $this->hasMany(CountryTranslation::class, 'country_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
