<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class Content
 * @package App\Models
 *
 * @property int $id
 * @property int $language_id
 * @property string $calculator_form_title
 * @property string $calculator_form_entry
 * @property string $calculator_form_visiting
 * @property string $calculator_form_travel
 * @property string $calculator_form_birthday
 * @property string $calculator_form_cover
 * @property string $calculator_form_start
 * @property string $calculator_form_end
 * @property string $calculator_form_error_end
 * @property string $calculator_form_error_max
 * @property string $calculator_form_submit
 * @property string $calculator_result_deductible
 * @property string $calculator_result_deductible_tooltip
 * @property string $calculator_result_unit
 * @property string $calculator_result_total
 * @property string $calculator_result_buy
 * @property string $calculator_result_details
 * @property string $inquiry_age
 * @property string $inquiry_cover
 * @property string $inquiry_days
 * @property string $inquiry_back
 * @property string $inquiry_next
 * @property string $inquiry_step1_title
 * @property string $inquiry_step1_header
 * @property string $inquiry_step1_description
 * @property string $inquiry_step1_agreement
 * @property string $inquiry_step2_title
 * @property string $inquiry_step2_basic
 * @property string $inquiry_step2_family
 * @property string $inquiry_step2_no
 * @property string $inquiry_step2_yes
 * @property string $inquiry_step2_people
 * @property string $inquiry_step2_cover
 * @property string $inquiry_step2_address
 * @property string $inquiry_step2_city
 * @property string $inquiry_step2_province
 * @property string $inquiry_step2_postalcode
 * @property string $inquiry_step2_phone
 * @property string $inquiry_step2_email
 * @property string $inquiry_step2_firstname
 * @property string $inquiry_step2_lastname
 * @property string $inquiry_step2_gender
 * @property string $inquiry_step2_male
 * @property string $inquiry_step2_female
 * @property string $inquiry_step2_birthday
 * @property string $inquiry_step2_insured
 * @property string $inquiry_step2_beneficiaries
 * @property string $inquiry_step2_alert
 * @property string $inquiry_step2_policy
 * @property string $inquiry_step2_start
 * @property string $inquiry_step2_end
 * @property string $inquiry_step2_arrival
 * @property string $inquiry_step2_error_end
 * @property string $inquiry_step2_error_max
 * @property string $inquiry_step3_title
 * @property string $inquiry_step3_fullname
 * @property string $inquiry_step3_gender
 * @property string $inquiry_step3_birthday
 * @property string $inquiry_step3_insured
 * @property string $inquiry_step3_beneficiaries
 * @property string $inquiry_step3_policy
 * @property string $inquiry_step3_start
 * @property string $inquiry_step3_end
 * @property string $inquiry_step3_arrival
 * @property string $inquiry_step3_deductible
 * @property string $inquiry_step3_unit_total
 * @property string $inquiry_step3_pay
 * @property string $inquiry_step3_methods
 * @property string $inquiry_step3_credit
 * @property string $inquiry_step3_bank
 * @property string $inquiry_step3_card_number
 * @property string $inquiry_step3_card_cvv
 * @property string $inquiry_step3_card_name
 * @property string $inquiry_step3_card_expiration
 * @property string $inquiry_step3_error_card_number
 * @property string $inquiry_step3_error_plan
 * @property string $inquiry_step3_transfer
 * @property string $inquiry_step3_message
 * @property string $inquiry_step4_title
 * @property string $inquiry_step4_greeting
 * @property string $inquiry_step4_message
 * @property string $inquiry_step4_thanks
 * @property string $inquiry_step4_back
 * @property bool $is_active
 *
 * @property Language $language
 */
class Content extends Model
{
    public $timestamps = false;
    protected $table = 'contents';
    protected $fillable = [
        'id',
        'language_id',
        'calculator_form_title',
        'calculator_form_entry',
        'calculator_form_visiting',
        'calculator_form_travel',
        'calculator_form_birthday',
        'calculator_form_cover',
        'calculator_form_start',
        'calculator_form_end',
        'calculator_form_error_end',
        'calculator_form_error_max',
        'calculator_form_submit',
        'calculator_result_deductible',
        'calculator_result_deductible_tooltip',
        'calculator_result_unit',
        'calculator_result_total',
        'calculator_result_buy',
        'calculator_result_details',
        'inquiry_age',
        'inquiry_cover',
        'inquiry_days',
        'inquiry_back',
        'inquiry_next',
        'inquiry_step1_title',
        'inquiry_step1_header',
        'inquiry_step1_description',
        'inquiry_step1_agreement',
        'inquiry_step2_title',
        'inquiry_step2_basic',
        'inquiry_step2_family',
        'inquiry_step2_no',
        'inquiry_step2_yes',
        'inquiry_step2_people',
        'inquiry_step2_cover',
        'inquiry_step2_address',
        'inquiry_step2_city',
        'inquiry_step2_province',
        'inquiry_step2_postalcode',
        'inquiry_step2_phone',
        'inquiry_step2_email',
        'inquiry_step2_firstname',
        'inquiry_step2_lastname',
        'inquiry_step2_gender',
        'inquiry_step2_male',
        'inquiry_step2_female',
        'inquiry_step2_birthday',
        'inquiry_step2_insured',
        'inquiry_step2_beneficiaries',
        'inquiry_step2_alert',
        'inquiry_step2_policy',
        'inquiry_step2_start',
        'inquiry_step2_end',
        'inquiry_step2_arrival',
        'inquiry_step2_error_end',
        'inquiry_step2_error_max',
        'inquiry_step3_title',
        'inquiry_step3_fullname',
        'inquiry_step3_gender',
        'inquiry_step3_birthday',
        'inquiry_step3_insured',
        'inquiry_step3_beneficiaries',
        'inquiry_step3_policy',
        'inquiry_step3_start',
        'inquiry_step3_end',
        'inquiry_step3_arrival',
        'inquiry_step3_deductible',
        'inquiry_step3_unit_total',
        'inquiry_step3_pay',
        'inquiry_step3_methods',
        'inquiry_step3_credit',
        'inquiry_step3_bank',
        'inquiry_step3_card_number',
        'inquiry_step3_card_cvv',
        'inquiry_step3_card_name',
        'inquiry_step3_card_expiration',
        'inquiry_step3_error_card_number',
        'inquiry_step3_error_plan',
        'inquiry_step3_transfer',
        'inquiry_step3_message',
        'inquiry_step4_title',
        'inquiry_step4_greeting',
        'inquiry_step4_message',
        'inquiry_step4_thanks',
        'inquiry_step4_back',
        'is_active',
    ];

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class, 'language_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
