<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class CompanyTranslation
 * @package App\Models
 *
 * @property int $id
 * @property int $company_id
 * @property int $language_id
 * @property string $name
 * @property string $description
 * @property bool $is_active
 *
 * @property Company $company
 * @property Language $language
 */
class CompanyTranslation extends Model
{
    public $timestamps = false;
    protected $table = 'company_translations';
    protected $fillable = [
        'id',
        'company_id',
        'language_id',
        'name',
        'description',
        'is_active',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class, 'language_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
