<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class Company
 * @package App\Models
 *
 * @property int $id
 * @property string $slug
 * @property string $logo
 * @property string $url
 * @property int $min_cost
 * @property bool $is_active
 *
 * @property Collection<Plan> $plans
 * @property Collection<CompanyTranslation> $translations
 */
class Company extends Model
{
    public $timestamps = false;
    protected $table = 'companies';
    protected $fillable = [
        'id',
        'slug',
        'logo',
        'name',
        'min_cost',
        'is_active',
    ];

    public function plans(): HasMany
    {
        return $this->hasMany(Plan::class, 'company_id');
    }

    public function translations(): HasMany
    {
        return $this->hasMany(CompanyTranslation::class, 'company_id');
    }

    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
