<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PasswordResetMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public string $name,
        public string $username,
        public string $panelLabel,
        public string $newPassword,
    ) {
    }

    public function build(): self
    {
        return $this->subject("Your new password for {$this->panelLabel}")
            ->view('emails.password-reset')
            ->with([
                'name' => $this->name,
                'username' => $this->username,
                'panelLabel' => $this->panelLabel,
                'newPassword' => $this->newPassword,
            ]);
    }
}
