<?php

namespace App\Http\Requests\Inquiry;

use Illuminate\Foundation\Http\FormRequest;

class SubmitInquiryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'address'           => 'required|string',
            'apiKey'            => 'required|string|exists:agents,id',
            'arrived_at'        => 'required|string',
            'birthdays'         => 'required|array',
            'birthdays.*'       => 'required|date|date_format:Y-m-d',
            'card_cvv'          => 'sometimes|nullable|integer|gt:0',
            'card_expiration'   => 'sometimes|nullable|string',
            'card_name'         => 'sometimes|nullable|string',
            'card_number'       => 'sometimes|nullable|string|regex:#^[0-9]{16}$#',
            'city'              => 'required|string|max:255',
            'deductible_ids'    => 'required|array',
            'deductible_ids.*'  => 'required|integer|exists:deductibles,id',
            'email'             => 'required|email:rfc,dns',
            'ended_at'          => 'required|string',
            'first_names'       => 'required|array',
            'first_names.*'     => 'required|string|max:255',
            'genders'           => 'required|array',
            'genders.*'         => 'required|string|in:Male,Female',
            'insurance_cover'   => 'required|integer|exists:prices,insurance_cover',
            'is_entry'          => 'required|boolean',
            'last_names'        => 'required|array',
            'last_names.*'      => 'required|string|max:255',
            'message'           => 'nullable|string',
            'phone'             => 'required|string',
            'postal_code'       => 'required|string',
            'price_ids'         => 'required|array',
            'price_ids.*'       => 'required|integer|exists:prices,id',
            'province_id'       => 'required|integer|exists:provinces,id',
            'started_at'        => 'required|string',
            'token'             => 'required|string',
            'transfer_password' => 'sometimes|nullable|string',
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'address'           => $this->post('address'),
            'apiKey'            => $this->header('API-Key'),
            'arrived_at'        => $this->post('arrived_at'),
            'birthdays'         => explode(',', $this->post('birthdays')),
            'card_cvv'          => $this->post('card_cvv'),
            'card_expiration'   => $this->post('card_expiration'),
            'card_name'         => $this->post('card_name'),
            'card_number'       => $this->post('card_number'),
            'city'              => $this->post('city'),
            'deductible_ids'    => explode(',', $this->post('deductible_ids')),
            'email'             => $this->post('email'),
            'ended_at'          => $this->post('ended_at'),
            'first_names'       => explode(',', $this->post('first_names')),
            'genders'           => explode(',', $this->post('genders')),
            'insurance_cover'   => $this->post('insurance_cover'),
            'is_entry'          => $this->post('is_entry'),
            'last_names'        => explode(',', $this->post('last_names')),
            'message'           => $this->post('message'),
            'phone'             => $this->post('phone'),
            'postal_code'       => $this->post('postal_code'),
            'price_ids'         => explode(',', $this->post('price_ids')),
            'province_id'       => $this->post('province_id'),
            'started_at'        => $this->post('started_at'),
            'token'             => $this->bearerToken(),
            'transfer_password' => $this->post('transfer_password'),
        ]);
    }
}
