<?php

namespace App\Http\Requests\Inquiry;

use Illuminate\Foundation\Http\FormRequest;

class GetFormOptionsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'apiKey'   => 'required|string|exists:agents,id',
            'language' => 'required|string|exists:languages,code',
            'token'    => 'required|string',
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'apiKey'   => $this->header('API-Key'),
            'language' => $this->header('Accept-Language'),
            'token'    => $this->bearerToken(),
        ]);
    }
}
