<?php

namespace App\Http\Requests\Authentication;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'apiKey'   => 'required|string|exists:agents,id',
            'username' => 'required|string|max:255',
            'password' => 'required|string|max:255',
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'apiKey'   => $this->header('API-Key'),
            'username' => $this->post('username'),
            'password' => $this->post('password'),
        ]);
    }
}
