<?php

namespace App\Http\Controllers\Authentication;

use App\Http\Controllers\ApiController;
use App\Http\Requests\Authentication\CheckRequest;

/**
 * @OA\Get(
 *   path="/api/auth/check",
 *   tags={"Authentication"},
 *   summary="Check JWT Token",
 *   operationId="auth_check",
 *   security={{"auth":{}}},
 *
 *   @OA\Parameter(name="Accept-Language", in="header", description="Accept-Language", required=true, example="en", @OA\Schema(type="string")),
 *   @OA\Parameter(name="API-Key", in="header", description="API-Key", required=true, example="", @OA\Schema(type="string")),
 *
 *   @OA\Response(response=200, description="success")
 * )
 */
class CheckController extends ApiController
{
    public function __invoke(CheckRequest $request)
    {
        return $this->success();
    }
}
