<?php

namespace App\Filament\Custom;

use App\Models\Company;
use App\Models\Country;
use App\Models\Language;
use App\Models\Plan;
use App\Models\Province;
use Exception;
use Filament\Tables\Filters\SelectFilter;
use Illuminate\Database\Eloquent\Builder;

class Search
{
    /**
     * @throws Exception
     */
    public static function company(): SelectFilter
    {
        return SelectFilter::make('company_id')
            ->label('Company')
            ->placeholder('Please select a company')
            ->searchable()
            ->options(Company::query()->orderBy('slug')->pluck('slug', 'id'))
            ->getSearchResultsUsing(function (string $search): array {
                return Company::query()
                    ->where(function (Builder $builder) use ($search) {
                        $search = self::filterTerm($search);
                        $builder->where('slug', 'LIKE', "%$search%");
                    })
                    ->pluck('slug', 'id')
                    ->toArray();
            });
    }

    private static function filterTerm(string $search): string
    {
        return str_replace(['\\', '_', '%'], ['\\\\', '\\_', '\\%'], $search);
    }

    /**
     * @throws Exception
     */
    public static function country(): SelectFilter
    {
        return SelectFilter::make('country_id')
            ->label('Country')
            ->placeholder('Please select a country')
            ->searchable()
            ->options(Country::query()->orderBy('slug')->pluck('slug', 'id'))
            ->getSearchResultsUsing(function (string $search): array {
                return Country::query()
                    ->where(function (Builder $builder) use ($search) {
                        $search = self::filterTerm($search);
                        $builder->where('slug', 'LIKE', "%$search%");
                    })
                    ->pluck('slug', 'id')
                    ->toArray();
            });
    }

    /**
     * @throws Exception
     */
    public static function language(): SelectFilter
    {
        return SelectFilter::make('language_id')
            ->label('Language')
            ->placeholder('Please select a language')
            ->searchable()
            ->options(Language::query()->orderBy('name')->pluck('name', 'id'))
            ->getSearchResultsUsing(function (string $search): array {
                return Language::query()
                    ->where(function (Builder $builder) use ($search) {
                        $search = self::filterTerm($search);
                        $builder->where('name', 'LIKE', "%$search%");
                    })
                    ->pluck('name', 'id')
                    ->toArray();
            });
    }

    /**
     * @throws Exception
     */
    public static function plan(): SelectFilter
    {
        return SelectFilter::make('plan_id')
            ->label('Plan')
            ->placeholder('Please select a plan')
            ->searchable()
            ->options(Plan::query()->orderBy('slug')->pluck('slug', 'id'))
            ->getSearchResultsUsing(function (string $search): array {
                return Plan::query()
                    ->where(function (Builder $builder) use ($search) {
                        $search = self::filterTerm($search);
                        $builder->where('slug', 'LIKE', "%$search%");
                    })
                    ->pluck('slug', 'id')
                    ->toArray();
            });
    }

    /**
     * @throws Exception
     */
    public static function province(): SelectFilter
    {
        return SelectFilter::make('province_id')
            ->label('Province')
            ->placeholder('Please select a province')
            ->searchable()
            ->options(Province::query()->orderBy('slug')->pluck('slug', 'id'))
            ->getSearchResultsUsing(function (string $search): array {
                return Province::query()
                    ->where(function (Builder $builder) use ($search) {
                        $search = self::filterTerm($search);
                        $builder->where('slug', 'LIKE', "%$search%");
                    })
                    ->pluck('slug', 'id')
                    ->toArray();
            });
    }
}
