<?php

namespace App\Filament\Custom;

use Filament\Actions\Action;
use Filament\Notifications\Notification;

class Actions
{
    public static function toggleActive(): Action
    {
        return Action::make('toggleActive')
            ->label(fn($record) => $record->is_active ? 'Deactivate' : 'Activate')
            ->color(fn($record) => $record->is_active ? 'warning' : 'success')
            ->icon(fn($record) => 'heroicon-m-' . ($record->is_active ? 'x': 'check') . '-circle')
            ->action(function ($record) {
                $record->update(['is_active' => !$record->is_active]);
                Notification::make('success')
                    ->success()
                    ->title('Success!')
                    ->body('Status successfully changed.')
                    ->send();
            })
            ->requiresConfirmation()
            ->visible(fn($record) => isset($record->is_active));
    }
}
