<?php

namespace App\Filament\Agent\Resources\Prices\Schemas;

use App\Filament\Custom\Create;
use Exception;
use Filament\Forms\Components\Checkbox;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class PriceForm
{
    /**
     * @throws Exception
     */
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Create::plan()
                    ->columnSpanFull()
                    ->required(),
                TextInput::make('age_from')
                    ->label('From Age')
                    ->required()
                    ->integer()
                    ->minValue(0),
                TextInput::make('To Age')
                    ->integer()
                    ->minValue(0),
                TextInput::make('insurance_cover')
                    ->required()
                    ->integer()
                    ->minValue(0),
                TextInput::make('daily_cost')
                    ->numeric()
                    ->minValue(0),
                Checkbox::make('is_entry')
                    ->label('Entry')
                    ->inline(false)
                    ->default(true),
                Checkbox::make('is_active')
                    ->label('Active')
                    ->inline(false)
                    ->default(true),
            ]);
    }
}
