<?php

namespace App\Filament\Agent\Resources\Deductibles\Tables;

use App\Filament\Custom\Columns;
use App\Filament\Custom\Search;
use Exception;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class DeductiblesTable
{
    /**
     * @throws Exception
     */
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                TextColumn::make('company.slug')
                    ->label('Company'),
                TextColumn::make('slug')
                    ->searchable(isIndividual: true, isGlobal: false)
                    ->sortable(),
                Columns::toggleIcon(),
            ])
            ->filters([
                Search::company(),
            ])
            ->recordActions([])
            ->toolbarActions([]);
    }
}
