<?php

namespace App\Filament\Agent\Resources\Companies\Tables;

use App\Filament\Custom\Columns;
use Exception;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class CompaniesTable
{
    /**
     * @throws Exception
     */
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                TextColumn::make('slug')
                    ->label('Slug')
                    ->searchable(isIndividual: true, isGlobal: false)
                    ->sortable(),
                Columns::image('logo', 'Logo'),
                Columns::toggleIcon(),
            ])
            ->filters([])
            ->recordActions([])
            ->toolbarActions([]);
    }
}
