<?php

namespace App\Filament\Agent\Resources\Companies;

use App\Filament\Agent\Resources\Companies\Pages\CreateCompany;
use App\Filament\Agent\Resources\Companies\Pages\EditCompany;
use App\Filament\Agent\Resources\Companies\Pages\ListCompanies;
use App\Filament\Agent\Resources\Companies\Schemas\CompanyForm;
use App\Filament\Agent\Resources\Companies\Tables\CompaniesTable;
use App\Models\Company;
use App\Providers\Filament\AgentPanelProvider;
use Exception;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use UnitEnum;

class CompanyResource extends Resource
{
    protected static ?string $model = Company::class;

    protected static string|UnitEnum|null $navigationGroup = AgentPanelProvider::INSURANCE;

    protected static ?int $navigationSort = 1;

    protected static ?string $recordTitleAttribute = 'slug';

    /**
     * @throws Exception
     */
    public static function form(Schema $schema): Schema
    {
        return CompanyForm::configure($schema);
    }

    /**
     * @throws Exception
     */
    public static function table(Table $table): Table
    {
        return CompaniesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListCompanies::route('/'),
            'create' => CreateCompany::route('/create'),
            'edit'   => EditCompany::route('/{record}/edit'),
        ];
    }
}
