<?php

namespace App\Filament\Admin\Resources\Provinces\Tables;

use App\Filament\Custom\Actions;
use App\Filament\Custom\Columns;
use App\Filament\Custom\Search;
use Exception;
use Filament\Actions\DeleteAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class ProvincesTable
{
    /**
     * @throws Exception
     */
    public static function configure(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('id')
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                TextColumn::make('country.slug')
                    ->label('Country'),
                TextColumn::make('slug')
                    ->searchable(isIndividual: true, isGlobal: false)
                    ->sortable(),
                Columns::toggleIcon(),
            ])
            ->filters([
                Search::country(),
            ])
            ->recordActions([
                Actions::toggleActive(),
                DeleteAction::make()->label(''),
            ])
            ->toolbarActions([]);
    }
}
