<?php

namespace App\Filament\Admin\Resources\Prices\Tables;

use App\Filament\Custom\Actions;
use App\Filament\Custom\Columns;
use App\Filament\Custom\Search;
use Exception;
use Filament\Actions\DeleteAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class PricesTable
{
    /**
     * @throws Exception
     */
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                TextColumn::make('plan.slug')
                    ->label('Plan'),
                TextColumn::make('age_from')
                    ->label('From Age'),
                TextColumn::make('age_to')
                    ->label('To Age'),
                TextColumn::make('insurance_cover')
                    ->label('Insurance Cover'),
                TextColumn::make('daily_cost')
                    ->label('Daily Cost'),
                Columns::toggleIcon('is_entry', 'Entry'),
                Columns::toggleIcon(),
            ])
            ->filters([
                Search::plan(),
            ])
            ->recordActions([
                Actions::toggleActive(),
                DeleteAction::make()->label(''),
            ])
            ->toolbarActions([]);
    }
}
