<?php

namespace App\Filament\Admin\Resources\Prices;

use App\Filament\Admin\Resources\Prices\Pages\CreatePrice;
use App\Filament\Admin\Resources\Prices\Pages\EditPrice;
use App\Filament\Admin\Resources\Prices\Pages\ListPrices;
use App\Filament\Admin\Resources\Prices\RelationManagers\TranslationsRelationManager;
use App\Filament\Admin\Resources\Prices\Schemas\PriceForm;
use App\Filament\Admin\Resources\Prices\Tables\PricesTable;
use App\Models\Price;
use App\Providers\Filament\AdminPanelProvider;
use Exception;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use UnitEnum;

class PriceResource extends Resource
{
    protected static ?string $model = Price::class;

    protected static string|UnitEnum|null $navigationGroup = AdminPanelProvider::INSURANCE;

    protected static ?int $navigationSort = 3;

    protected static ?string $recordTitleAttribute = 'id';

    /**
     * @throws Exception
     */
    public static function form(Schema $schema): Schema
    {
        return PriceForm::configure($schema);
    }

    /**
     * @throws Exception
     */
    public static function table(Table $table): Table
    {
        return PricesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListPrices::route('/'),
            'create' => CreatePrice::route('/create'),
            'edit'   => EditPrice::route('/{record}/edit'),
        ];
    }
}
