<?php

namespace App\Filament\Admin\Resources\Deductibles\Tables;

use App\Filament\Custom\Actions;
use App\Filament\Custom\Columns;
use App\Filament\Custom\Search;
use Exception;
use Filament\Actions\DeleteAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class DeductiblesTable
{
    /**
     * @throws Exception
     */
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                TextColumn::make('company.slug')
                    ->label('Company'),
                TextColumn::make('slug')
                    ->searchable(isIndividual: true, isGlobal: false)
                    ->sortable(),
                TextColumn::make('amount')
                    ->prefix('$')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('discount')
                    ->prefix('%')
                    ->numeric()
                    ->sortable(),
                Columns::toggleIcon(),
            ])
            ->filters([
                Search::company(),
            ])
            ->recordActions([
                Actions::toggleActive(),
                DeleteAction::make()->label(''),
            ])
            ->toolbarActions([]);
    }
}
