<?php

namespace App\Filament\Admin\Resources\Contents\Tables;

use App\Filament\Custom\Actions;
use App\Filament\Custom\Columns;
use Exception;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class ContentsTable
{
    /**
     * @throws Exception
     */
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                TextColumn::make('language.name')
                    ->label('Language'),
                Columns::toggleIcon(),
            ])
            ->filters([])
            ->recordActions([
                Actions::toggleActive(),
            ])
            ->toolbarActions([]);
    }
}
