<?php

namespace App\Filament\Admin\Resources\Contents;

use App\Filament\Admin\Resources\Contents\Pages\CreateContent;
use App\Filament\Admin\Resources\Contents\Pages\EditContent;
use App\Filament\Admin\Resources\Contents\Pages\ListContents;
use App\Filament\Admin\Resources\Contents\Schemas\ContentForm;
use App\Filament\Admin\Resources\Contents\Tables\ContentsTable;
use App\Models\Content;
use App\Providers\Filament\AdminPanelProvider;
use Exception;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use UnitEnum;

class ContentResource extends Resource
{
    protected static ?string $model = Content::class;

    protected static string|UnitEnum|null $navigationGroup = AdminPanelProvider::BASE;

    protected static ?int $navigationSort = 2;

    protected static ?string $recordTitleAttribute = 'id';

    /**
     * @throws Exception
     */
    public static function form(Schema $schema): Schema
    {
        return ContentForm::configure($schema);
    }

    /**
     * @throws Exception
     */
    public static function table(Table $table): Table
    {
        return ContentsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListContents::route('/'),
            'create' => CreateContent::route('/create'),
            'edit'   => EditContent::route('/{record}/edit'),
        ];
    }
}
