<?php

namespace App\Filament\Admin\Resources\Companies\Tables;

use App\Filament\Custom\Actions;
use App\Filament\Custom\Columns;
use Exception;
use Filament\Actions\DeleteAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class CompaniesTable
{
    /**
     * @throws Exception
     */
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                Columns::image('logo', 'Logo'),
                TextColumn::make('slug')
                    ->label('Slug')
                    ->searchable(isIndividual: true, isGlobal: false)
                    ->sortable(),
                TextColumn::make('url')
                    ->label('URL')
                    ->searchable(isIndividual: true, isGlobal: false)
                    ->sortable(),
                TextColumn::make('min_cost')
                    ->label('Minimum Cost')
                    ->prefix('$')
                    ->sortable(),
                Columns::toggleIcon(),
            ])
            ->filters([])
            ->recordActions([
                Actions::toggleActive(),
                DeleteAction::make()->label(''),
            ])
            ->toolbarActions([]);
    }
}
