<?php

namespace App\Filament\Admin\Resources\Cities\Tables;

use App\Filament\Custom\Actions;
use App\Filament\Custom\Columns;
use App\Filament\Custom\Search;
use Exception;
use Filament\Actions\DeleteAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class CitiesTable
{
    /**
     * @throws Exception
     */
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                TextColumn::make('province.country.slug')
                    ->label('Country'),
                TextColumn::make('province.slug')
                    ->label('Province'),
                TextColumn::make('slug')
                    ->searchable(isIndividual: true, isGlobal: false)
                    ->sortable(),
                Columns::toggleIcon(),
            ])
            ->filters([
                Search::province(),
            ])
            ->recordActions([
                Actions::toggleActive(),
                DeleteAction::make()->label(''),
            ])
            ->toolbarActions([]);
    }
}
