<?php

namespace App\Filament\Admin\Resources\Agents\RelationManagers;

use App\Filament\Custom\Actions;
use App\Filament\Custom\Columns;
use Exception;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Model;

class SessionsRelationManager extends RelationManager
{
    protected static string $relationship = 'sessions';

    /**
     * @throws Exception
     */
    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('id')
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                TextColumn::make('id')
                    ->label('ID')
                    ->searchable(isIndividual: true, isGlobal: false)
                    ->sortable(),
                TextColumn::make('expired_at')
                    ->label('Expiry Date')
                    ->dateTime(),
                Columns::toggleIcon(),
            ])
            ->filters([])
            ->headerActions([])
            ->recordActions([
                Actions::toggleActive(),
            ])
            ->toolbarActions([]);
    }

    protected function canCreate(): bool
    {
        return false;
    }

    protected function canDelete(Model $record): bool
    {
        return false;
    }
}
