<?php

namespace App\Filament\Admin\Resources\Agents\RelationManagers;

use App\Filament\Custom\Columns;
use App\Models\Inquiry;
use Exception;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class InquiriesRelationManager extends RelationManager
{
    protected static string $relationship = 'inquiries';

    /**
     * @throws Exception
     */
    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('id')
            ->columns([
                TextColumn::make('row')
                    ->label('#')
                    ->rowIndex(),
                TextColumn::make('city_id')
                    ->label('City')
                    ->formatStateUsing(fn(Inquiry $record) => Str::title(implode(', ', [
                        $record->city->slug,
                        $record->city->province->slug,
                        $record->city->province->country->slug
                    ]))),
                TextColumn::make('id')
                    ->label('People Count')
                    ->formatStateUsing(fn(Inquiry $record) => $record->people->count()),
                TextColumn::make('insurance_cover')
                    ->label('Insurance Cover')
                    ->numeric(),
                Columns::toggleIcon('is_entry', 'Entry'),
                Columns::toggleIcon('is_deal', 'Deal'),
            ])
            ->filters([])
            ->headerActions([])
            ->recordActions([])
            ->toolbarActions([]);
    }

    protected function canCreate(): bool
    {
        return false;
    }

    protected function canEdit(Model $record): bool
    {
        return false;
    }

    protected function canDelete(Model $record): bool
    {
        return false;
    }
}
