<?php

namespace App\Enums;

enum DestinationType: string
{
    case CANADA = 'canada';
    case WORLDWIDE_EXCLUDING_USA = 'worldwide_excluding_usa';
    case WORLDWIDE_INCLUDING_USA = 'worldwide_including_usa';

    public function label(): string
    {
        return match($this) {
            self::CANADA => 'Canada (Out of Province)',
            self::WORLDWIDE_EXCLUDING_USA => 'Worldwide (Excluding USA)',
            self::WORLDWIDE_INCLUDING_USA => 'Worldwide (Including USA)',
        };
    }

    public static function forSelect(): array
    {
        $cases = [];
        foreach (self::cases() as $case) {
            $cases[$case->value] = $case->label();
        }
        return $cases;
    }
}